<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Soap\Engine\Metadata\Collection;

use Gls\GlsPoland\Soap\Engine\Metadata\Model\Parameter;

/**
 * @implements \IteratorAggregate<int, Parameter>
 */
final class ParameterCollection implements \Countable, \IteratorAggregate
{
    /**
     * @var list<Parameter>
     */
    private $parameters;

    /**
     * @no-named-arguments
     */
    public function __construct(Parameter ...$parameters)
    {
        $this->parameters = $parameters;
    }

    /**
     * @return \Iterator<int, Parameter>
     */
    public function getIterator(): \Iterator
    {
        return new \ArrayIterator($this->parameters);
    }

    public function count(): int
    {
        return count($this->parameters);
    }

    public function map(callable $callback): array
    {
        return array_map($callback, $this->parameters);
    }
}
