<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\MessageHandler\Carrier\Assembler;

use Gls\GlsPoland\PrestaShop\DTO;
use Gls\GlsPoland\PrestaShop\Message\CreateCarrierCommandInterface;
use Gls\GlsPoland\PrestaShop\ObjectModel\Repository\ZoneRepository;

final class ZonesAssembler implements CarrierAssemblerInterface
{
    private $zoneRepository;

    public function __construct(ZoneRepository $zoneRepository)
    {
        $this->zoneRepository = $zoneRepository;
    }

    public function assemble(DTO\Carrier $carrier, CreateCarrierCommandInterface $command): void
    {
        foreach ($command->getCountryIsoCodes() as $isoCode) {
            if ($zone = $this->zoneRepository->findOneByCountryIsoCode((string) $isoCode)) {
                $carrier->addZone($zone);
            }
        }
    }
}
