<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Message;

class CreateAdminTabCommand
{
    private $className;
    private $parentClassName;
    private $name;
    private $visible;
    private $icon;
    private $routeName;
    private $moduleName;

    /**
     * @param string|string[]|null $name
     */
    public function __construct(
        string $class_name,
        ?string $parent_class_name = null,
        $name = null,
        bool $visible = true,
        ?string $icon = null,
        ?string $route_name = null,
        ?string $module_name = null
    ) {
        $this->className = $class_name;
        $this->parentClassName = $parent_class_name;
        $this->name = $name;
        $this->visible = $visible;
        $this->icon = $icon;
        $this->routeName = $route_name;
        $this->moduleName = $module_name;
    }

    public function getClassName(): string
    {
        return $this->className;
    }

    public function getParentClassName(): ?string
    {
        return $this->parentClassName;
    }

    /**
     * @return string|string[]|null
     */
    public function getName()
    {
        return $this->name;
    }

    public function isVisible(): bool
    {
        return $this->visible;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function getRouteName(): ?string
    {
        return $this->routeName;
    }

    public function getModuleName(): ?string
    {
        return $this->moduleName;
    }
}
