<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Filters;

use Gls\GlsPoland\PrestaShop\Grid\Definition\Factory\ConsignmentGridDefinitionFactory;
use PrestaShop\PrestaShop\Core\Search\Filters;

final class ConsignmentFilters extends Filters
{
    protected $filterId = ConsignmentGridDefinitionFactory::GRID_ID;

    public static function getDefaults(): array
    {
        return [
            'limit' => 20,
            'offset' => 0,
            'orderBy' => 'id',
            'sortOrder' => 'DESC',
            'filters' => [],
        ];
    }

    public function addFilter(array $parameters = []): self
    {
        if (is_callable('parent::addFilter')) {
            parent::addFilter($parameters);
        } else {
            $filters = array_replace($this->getFilters(), $parameters);
            $this->set('filters', $filters);
        }

        return $this;
    }
}
