<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Grid\Definition\Factory;

use PrestaShop\PrestaShop\Core\Grid\Action\Row\AccessibilityChecker\AccessibilityCheckerInterface;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollection;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\RowActionCollectionInterface;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\LinkRowAction;
use PrestaShop\PrestaShop\Core\Grid\Action\Row\Type\SubmitRowAction;
use PrestaShop\PrestaShop\Core\Grid\Definition\Factory\AbstractGridDefinitionFactory;

/**
 * @mixin AbstractGridDefinitionFactory
 */
trait ConsignmentGridRowActionsTrait
{
    /**
     * @var AccessibilityCheckerInterface
     */
    private $deleteAccessibilityChecker;

    private function getRowActions(): RowActionCollectionInterface
    {
        return (new RowActionCollection())
            ->add(
                (new LinkRowAction('print_labels'))
                    ->setName($this->trans('Print label', [], 'Modules.Glspoland.Consignment'))
                    ->setOptions([
                        'route' => 'admin_gls_poland_consignments_print_labels',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id',
                    ])
                    ->setIcon('print')
            )
            ->add(
                (new SubmitRowAction('delete'))
                    ->setName($this->trans('Delete', [], 'Admin.Actions'))
                    ->setOptions([
                        'route' => 'admin_gls_poland_consignments_delete',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id',
                        'confirm_message' => $this->trans('Delete selected item?', [], 'Admin.Notifications.Warning'),
                        'accessibility_checker' => $this->deleteAccessibilityChecker,
                    ])
                    ->setIcon('delete')
            )
            ->add(
                (new LinkRowAction('print_pickup_receipt'))
                    ->setName($this->trans('Print pickup receipt', [], 'Modules.Glspoland.Consignment'))
                    ->setOptions([
                        'route' => 'admin_gls_poland_consignments_print_pickup_receipt',
                        'route_param_name' => 'id',
                        'route_param_field' => 'id',
                        'accessibility_checker' => static function (array $dataRow): bool {
                            return isset($dataRow['pickup_id']);
                        },
                    ])
                    ->setIcon('print')
            );
    }
}
