<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Module;

use Gls\GlsPoland\PrestaShop\Checkout\ModuleCheckoutInterface;
use Gls\GlsPoland\PrestaShop\ModuleRepository;
use Symfony\Component\HttpFoundation\Request;

/**
 * @mixin ModuleCheckoutInterface
 */
trait ModuleControllerCheckerTrait
{
    public static function supports(\FrontControllerCore $controller, ?ModuleRepository $moduleRepository = null, ?Request $request = null): bool
    {
        if (!$controller instanceof \ModuleFrontControllerCore) {
            return false;
        }

        if (self::getModuleName() !== $controller->module->name) {
            return false;
        }

        if (null === $request) {
            return false;
        }

        $controllerName = $request->query->get('controller', '');
        $parts = explode('-', $controllerName);
        $controllerName = end($parts);

        return in_array($controllerName, self::getCheckoutControllerNames(), true);
    }

    /* @return string[] */
    /* abstract private static function getCheckoutControllerNames(): array; */
}
