<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Event;

use Symfony\Component\HttpFoundation\Request;

final class ValidateStepCompleteEvent extends AbstractCheckoutEvent
{
    private $requestParameters;
    private $complete = true;

    public function __construct(\Cart $cart, Request $request, array $requestParameters)
    {
        parent::__construct($cart, $request);
        $this->requestParameters = $requestParameters;
    }

    public function getRequestParameters(): array
    {
        return $this->requestParameters;
    }

    public function isComplete(): bool
    {
        return $this->complete;
    }

    public function setComplete(bool $complete): self
    {
        $this->complete = $complete;

        return $this;
    }
}
