<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout;

use Gls\GlsPoland\PrestaShop\Checkout\Event\AbstractCheckoutEvent;
use Symfony\Component\HttpFoundation\Request;

interface CheckoutResolverInterface
{
    public function resolve(?Request $request = null): ?CheckoutInterface;

    /**
     * Resolves checkout and - if the checkout subscribes to the passed event - calls its listener.
     *
     * @template T of AbstractCheckoutEvent
     *
     * @param T $event
     *
     * @return T
     */
    public function dispatch(AbstractCheckoutEvent $event): AbstractCheckoutEvent;
}
