<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Checkout\Availability;

use Gls\GlsPoland\Entity\Carrier;

final class WeightChecker implements CarrierAvailabilityCheckerInterface
{
    public function isAvailable(Carrier $carrier, \Cart $cart): bool
    {
        $maxWeight = 31.5;

        foreach ($cart->getProducts() as $product) {
            if ($maxWeight < (float) $product['weight']) {
                return false;
            }
        }

        return true;
    }
}
