<?php

declare(strict_types=1);

namespace Gls\GlsPoland\PrestaShop\Asset\DTO;

class Assets
{
    private $javaScripts = [];
    private $styleSheets = [];
    private $jsVariables = [];

    public function getJavaScripts(): array
    {
        return $this->javaScripts;
    }

    public function addJavaScript(string $path, array $options = []): self
    {
        $this->javaScripts[$path] = $options;

        return $this;
    }

    public function getStyleSheets(): array
    {
        return $this->styleSheets;
    }

    public function addStyleSheet(string $path, array $options = []): self
    {
        $this->styleSheets[$path] = $options;

        return $this;
    }

    public function getJavaScriptVariables(): array
    {
        return $this->jsVariables;
    }

    public function addJavaScriptVariable(string $name, $value): self
    {
        $this->jsVariables[$name] = $value;

        return $this;
    }
}
