<?php

declare(strict_types=1);

namespace Gls\GlsPoland\MessageHandler\Labels\Download;

use Gls\GlsPoland\AdePlus\Printout\LabelsPrintMode;
use Gls\GlsPoland\AdePlus\Printout\PrintoutInterface;
use Gls\GlsPoland\Entity\Consignment;

interface DownloadLabelsHandlerInterface
{
    public function downloadSingle(Consignment $consignment, LabelsPrintMode $printMode): PrintoutInterface;

    /**
     * @return array<PrintoutInterface>|(\Traversable<PrintoutInterface>&\Countable)
     */
    public function downloadSeparate(Consignment $consignment, LabelsPrintMode $printMode): iterable;

    public function setNext(self $handler): self;
}
