<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Message;

use Symfony\Component\Validator\Constraints as Assert;

class CreatePickupCommand
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank()
     * @Assert\Length(max="40")
     */
    private $description;

    /**
     * @var int[]
     *
     * @Assert\Count(min="1")
     * @Assert\All({
     *     @Assert\Type("int"),
     *     @Assert\GreaterThan(0)
     * })
     */
    private $consignmentIds;

    public function __construct(?string $description = null, int ...$consignmentIds)
    {
        $this->description = $description;
        $this->consignmentIds = $consignmentIds;
    }

    public function getDescription(): string
    {
        return $this->description ?? '';
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    /**
     * @return int[]
     */
    public function getConsignmentIds(): array
    {
        return $this->consignmentIds;
    }

    public function setConsignmentIds(array $consignmentIds): self
    {
        $this->consignmentIds = $consignmentIds;

        return $this;
    }
}
