<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\AdePlus\UserCredentials;
use Gls\GlsPoland\Form\DataMapper\UserCredentialsDataMapper;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class UserCredentialsType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('username', TextType::class, [
                'required' => false,
                'mapped' => false,
                'label' => $this->getTranslator()->trans('Username', [], 'Modules.Glspoland.Configuration'),
            ])
            ->add('password', PasswordType::class, [
                'required' => false,
                'mapped' => false,
                'label' => $this->getTranslator()->trans('Password', [], 'Admin.Global'),
            ])
            ->setDataMapper(new UserCredentialsDataMapper());
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefault('data_class', UserCredentials::class)
            ->setDefault('empty_data', null);
    }
}
