<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\AdePlus\Printout\PickupReceiptPrintMode;
use Gls\GlsPoland\Form\DataTransformer\PickupReceiptPrintModeDataTransformer;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class PickupReceiptPrintModeChoiceType extends AbstractType
{
    use TranslatorAwareTrait;

    public function getParent(): string
    {
        return ChoiceType::class;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->addModelTransformer(new PickupReceiptPrintModeDataTransformer());
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $translator = $this->getTranslator();

        $resolver
            ->setDefaults([
                'data_class' => null,
                'choices' => [
                    $translator->trans('With barcodes', [], 'Modules.Glspoland.Printout') => PickupReceiptPrintMode::WITH_BARCODES,
                    $translator->trans('Condensed', [], 'Modules.Glspoland.Printout') => PickupReceiptPrintMode::CONDENSED,
                    $translator->trans('Condensed, with description', [], 'Modules.Glspoland.Printout') => PickupReceiptPrintMode::CONDENSED_WITH_DESCRIPTION,
                ],
            ]);
    }
}
