<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Form\Type;

use Gls\GlsPoland\AdePlus\Services\Services;
use Gls\GlsPoland\Carrier\DTO\AdditionalServices;
use Gls\GlsPoland\Translation\TranslatorAwareTrait;
use PrestaShopBundle\Form\Admin\Type\SwitchType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class CarrierAdditionalServicesType extends AbstractType
{
    use TranslatorAwareTrait;

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('cashOnDelivery', SwitchType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Cash on delivery', [], 'Modules.Glspoland.Carrier'),
                'disabled' => !$options['domestic_carrier'],
                'attr' => [
                    'class' => 'js-domestic-only-service js-additional-service',
                    'data-service-id' => Services::CASH_ON_DELIVERY,
                ],
            ])
            ->add('documentReturn', SwitchType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Document return', [], 'Modules.Glspoland.Carrier'),
            ])
            ->add('saturdayDelivery', SwitchType::class, [
                'required' => false,
                'label' => $this->getTranslator()->trans('Saturday delivery', [], 'Modules.Glspoland.Carrier'),
                'disabled' => !$options['domestic_carrier'],
                'attr' => [
                    'class' => 'js-domestic-only-service js-additional-service',
                    'data-service-id' => Services::SATURDAY_DELIVERY,
                ],
            ])
            ->add('timeDefiniteService', TimeDefiniteServiceChoiceType::class, [
                'required' => false,
                'disabled' => !$options['domestic_carrier'],
                'label' => $this->getTranslator()->trans('Next day delivery', [], 'Modules.Glspoland.Carrier'),
                'placeholder' => $this->getTranslator()->trans('No', [], 'Admin.Global'),
                'attr' => [
                    'class' => 'js-domestic-only-service js-additional-service',
                ],
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'data_class' => AdditionalServices::class,
                'domestic_carrier' => true,
            ])
            ->setAllowedTypes('domestic_carrier', 'bool');
    }
}
