<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Configuration\Initializer;

use Doctrine\DBAL\Types\Type;
use Gls\GlsPoland\Doctrine\DBAL\Types\DateTimeImmutableType;
use Gls\GlsPoland\Doctrine\DBAL\Types\JsonType;

final class DoctrineTypesInitializer implements ConfigurationInitializerInterface
{
    private const TYPES = [
        JsonType::TYPE => JsonType::class,
        DateTimeImmutableType::TYPE => DateTimeImmutableType::class,
    ];

    public function init(): void
    {
        foreach (self::TYPES as $name => $class) {
            if (Type::hasType($name)) {
                continue;
            }

            Type::addType($name, $class);
        }
    }
}
