<?php

declare(strict_types=1);

namespace Gls\GlsPoland\Carrier;

final class TrackingUrlGenerator implements TrackingUrlGeneratorInterface
{
    private const PATTERN_PL = 'https://gls-group.com/PL/pl/sledzenie-paczek?match=%s';
    private const PATTERN_EN = 'https://gls-group.com/PL/en/parcel-tracking?match=%s';

    public function generate(string $parcelNumber, string $languageIsoCode = 'pl'): string
    {
        return sprintf('pl' === $languageIsoCode ? self::PATTERN_PL : self::PATTERN_EN, $parcelNumber);
    }
}
