<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Pickup;

final class ConsignmentIdsBinding implements \JsonSerializable
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var int
     */
    private $id_src;

    public function getPickupId(): int
    {
        return $this->id;
    }

    public function getPreparingBoxId(): int
    {
        return $this->id_src;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
