<?php

declare(strict_types=1);

namespace Gls\GlsPoland\AdePlus\Consignment;

use Gls\GlsPoland\AdePlus\Common\Services;

final class Parcel implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $number;

    /**
     * @var string|null
     */
    private $reference;

    /**
     * @var float
     */
    private $weight;

    /**
     * @var string|null
     */
    private $srv_ade;

    /**
     * @var Services|null
     */
    private $srv_bool;

    public function __construct(float $weightKg)
    {
        $this->weight = $weightKg;
    }

    public function getNumber(): ?string
    {
        return $this->number;
    }

    public function getReference(): ?string
    {
        return $this->reference;
    }

    public function withReference(?string $reference): Parcel
    {
        $new = clone $this;
        $new->reference = $reference;

        return $new;
    }

    public function getWeightKg(): float
    {
        return $this->weight;
    }

    public function withWeightKg(float $weight): Parcel
    {
        $new = clone $this;
        $new->weight = $weight;

        return $new;
    }

    public function getServicesAde(): ?string
    {
        return $this->srv_ade;
    }

    public function getServices(): ?Services
    {
        return $this->srv_bool;
    }

    public function withServices(?Services $services): Parcel
    {
        $new = clone $this;
        $new->srv_bool = $services;

        return $new;
    }

    public function jsonSerialize(): array
    {
        return get_object_vars($this);
    }
}
